/*skipper*/
//g++ -o skipper skipper.cpp -I ../EzWindows/include -L/usr/X11R6/lib -lX11 -L../EzWindows/lib -lezwin

#include<iostream>
#include<cmath>
#include"ezwin.h"
#define TERRAIN 5
#define RADIUS 3
#define INFLUENCE 5 ;
using namespace std;

//declaring a window
SimpleWindow w("RAVINDRA",22.5,16,Position(0,5));

//using a timer to delay time
void timer(int seconds){
  clock_t endwait=clock()+(CLOCKS_PER_SEC*seconds)/100;
  while(clock()<endwait);
}

//distance function
float Distance(float x1,float y1,float x2,float y2){
  float D;
  D=(x1-x2)*(x1-x2)+(y1-y2)*(y1-y2);D=sqrt(D);
  return D;
}

//clear terrain
void clear(float x,float r,float terrain[2250]){
   float W=0.01;int i=x/W;float y1,y2,y0=terrain[i],c=-r;float terrain1[2250];
   for(i=(x-r)/W;i<(x+r)/W;i++)if(i>=0&&i<2250)terrain1[i]=terrain[i];
   for(i=(x-r)/W;i<(x+r)/W;i++){
     y1=y0-sqrt(r*r-c*c);
     y2=y0+sqrt(r*r-c*c);c+=0.01;
     if(i>=0&&i<2250&&terrain[i]>y1&&terrain[i]<y2)terrain[i]=y1;
     else if(i>=0&&i<2250&&terrain[i]>y2)terrain[i]-=y2-y1;
     if(terrain[i]<0)terrain[i]=0;
     w.RenderRectangle(Position(i*W,16-terrain1[i]),Position((i+1)*W,16-terrain[i]),Cyan,false);
     w.RenderRectangle(Position(i*W,16-terrain[i]),Position((i+1)*W,16),Green,false);
   }
}

/*bomb trajectory main function*/
int skipper(float p,float q,float p2,float q2,float u,float A,float terrain[1000],float *score){
  u=2*u;A=A*0.017453292; //converting u to CGS units and A to radians
  float x=p,y=q;float r=0,Radius=3,D,Influence=5,t=0;float W=0.01;int i=x/W;float G=0;
  //defining a structure for fragments
  typedef struct {
   float x;
   float y;
   float A;
   float t;
   float r;
   int f;
   int g;
   }mini_missile;
  mini_missile m[5];
  //main trajectory
  while(x>=0&&x<22.5&&y>terrain[i]){
    y=q+u*sin(A)*t-490*t*t;
    x=p+u*cos(A)*t;i=x/W;
    w.RenderEllipse(Position(x,16-y),Position(x+0.1,16-y+.1),Red,false);
    timer(1);t+=0.0005; //using time delay function and increasing time
    w.RenderEllipse(Position(x,16-y),Position(x+0.1,16-y+.1),Cyan,false);
    }//while bracket

    //if tank2 is in certain range missile splits here
    if(x>=0&&x<22.5){
      t-=0.001;y=q+u*sin(A)*t-490*t*t;x=p+u*cos(A)*t;i=x/W;
      u=100;m[0].A=90;m[1].A=88;m[2].A=92;m[3].A=86;m[4].A=94;//giving some angles & velocity for fragments
      //initialising fragments parameters
      for(int j=0;j<5;j++){m[j].x=x;m[j].y=y;m[j].t=m[j].r=m[j].f=m[j].g=0;m[j].A=m[j].A*0.017453292;} 

      //using a single loop for all fragments so that they occur simultaneously
      while(G==0){
        //fragment 1
        i=m[0].x/W;
        if(m[0].x>=0&&m[0].x<22.5&&m[0].y>=terrain[i]&&m[0].f==0){
           m[0].y=y+u*sin(m[0].A)*m[0].t-500*m[0].t*m[0].t;
           m[0].x=x+u*cos(m[0].A)*m[0].t;
           w.RenderEllipse(Position(m[0].x,16-m[0].y),Position(m[0].x+0.02,16-m[0].y+.02),Red,false);
           m[0].t+=0.0005;
        }
        else if(m[0].x>=0&&m[0].x<22.5&&m[0].r<Radius/5){
          w.RenderEllipse(Position(m[0].x-m[0].r,16-m[0].y-m[0].r),Position(m[0].x+m[0].r,16-m[0].y+m[0].r),Yellow,false);m[0].r+=0.01;
        }
        else m[0].g++;
        //fragment 2
        i=m[1].x/W;
        if(m[1].x>=0&&m[1].x<22.5&&m[1].y>=terrain[i]&&m[1].f==0){
           m[1].y=y+u*sin(m[1].A)*m[1].t-500*m[1].t*m[1].t;
           m[1].x=x+u*cos(m[1].A)*m[1].t;
           w.RenderEllipse(Position(m[1].x,16-m[1].y),Position(m[1].x+0.02,16-m[1].y+.02),Red,false);
           m[1].t+=0.0005;
        }
        else if(m[1].x>=0&&m[1].x<22.5&&m[1].r<Radius/5){
          w.RenderEllipse(Position(m[1].x-m[1].r,16-m[1].y-m[1].r),Position(m[1].x+m[1].r,16-m[1].y+m[1].r),Yellow,false);m[1].r+=0.01;
        }
        else m[1].g++;
        //fragment 3
        i=m[2].x/W;
        if(m[2].x>=0&&m[2].x<22.5&&m[2].y>=terrain[i]&&m[2].f==0){
           m[2].y=y+u*sin(m[2].A)*m[2].t-500*m[2].t*m[2].t;
           m[2].x=x+u*cos(m[2].A)*m[2].t;
           w.RenderEllipse(Position(m[2].x,16-m[2].y),Position(m[2].x+0.02,16-m[2].y+.02),Red,false);
           m[2].t+=0.0005;
        }
        else if(m[2].x>=0&&m[2].x<22.5&&m[2].r<Radius/5){
          w.RenderEllipse(Position(m[2].x-m[2].r,16-m[2].y-m[2].r),Position(m[2].x+m[2].r,16-m[2].y+m[2].r),Yellow,false);m[2].r+=0.01;
        }
        else m[2].g++;
        //fragment 4
        i=m[3].x/W;
        if(m[3].x>=0&&m[3].x<22.5&&m[3].y>=terrain[i]&&m[3].f==0){
           m[3].y=y+u*sin(m[3].A)*m[3].t-500*m[3].t*m[3].t;
           m[3].x=x+u*cos(m[3].A)*m[3].t;
           w.RenderEllipse(Position(m[3].x,16-m[3].y),Position(m[3].x+0.02,16-m[3].y+.02),Red,false);
           m[3].t+=0.0005;
        }
        else if(m[3].x>=0&&m[3].x<22.5&&m[3].r<Radius/5){
          w.RenderEllipse(Position(m[3].x-m[3].r,16-m[3].y-m[3].r),Position(m[3].x+m[3].r,16-m[3].y+m[3].r),Yellow,false);m[3].r+=0.01;
        }
        else m[3].g++;
        //fragment 5
        i=m[4].x/W;
        if(m[4].x>=0&&m[4].x<22.5&&m[4].y>=terrain[i]&&m[4].f==0){
           m[4].y=y+u*sin(m[4].A)*m[4].t-500*m[4].t*m[4].t;
           m[4].x=x+u*cos(m[4].A)*m[4].t;
           w.RenderEllipse(Position(m[4].x,16-m[4].y),Position(m[4].x+0.02,16-m[4].y+.02),Red,false);
           m[4].t+=0.0005;
        }
        else if(m[4].x>=0&&m[4].x<22.5&&m[4].r<Radius/5){
          w.RenderEllipse(Position(m[4].x-m[4].r,16-m[4].y-m[4].r),Position(m[4].x+m[4].r,16-m[4].y+m[4].r),Yellow,false);m[4].r+=0.01;
        }
        else m[4].g++;


        timer(1);  //delaying time


        //fragment 1
        i=m[0].x/W;
        if(m[0].x>=0&&m[0].x<22.5&&m[0].y>=terrain[i]&&m[0].f==0){
          w.RenderEllipse(Position(m[0].x,16-m[0].y),Position(m[0].x+0.02,16-m[0].y+.02),Cyan,false);
        }
        else if(m[0].x>=0&&m[0].x<22.5&&m[0].r>=Radius/5&&m[0].f==0){
          w.RenderEllipse(Position(m[0].x-m[0].r,16-m[0].y-m[0].r),Position(m[0].x+m[0].r,16-m[0].y+m[0].r),Cyan,false);m[0].f++;
          //scoring
          D=Distance(m[0].x,m[0].y,p2,q2);
          if(D<Radius/10)*score=*score+140;
          else if(D<Radius/5)*score=*score+80;
          D=Distance(m[0].x,m[0].y,p,q);
          if(D<Radius/10)*score=*score-140;
          else if(D<Radius/5)*score=*score-80;
          clear(m[0].x,Radius/5,terrain);
        }
        //fragment 2
        i=m[1].x/W;
        if(m[1].x>=0&&m[1].x<22.5&&m[1].y>=terrain[i]&&m[1].f==0){
          w.RenderEllipse(Position(m[1].x,16-m[1].y),Position(m[1].x+0.02,16-m[1].y+.02),Cyan,false);
        }
        else if(m[1].x>=0&&m[1].x<22.5&&m[1].r>=Radius/5&&m[1].f==0){
          w.RenderEllipse(Position(m[1].x-m[1].r,16-m[1].y-m[1].r),Position(m[1].x+m[1].r,16-m[1].y+m[1].r),Cyan,false);m[1].f++;
          //scoring
          D=Distance(m[1].x,m[1].y,p2,q2);
          if(D<Radius/10)*score=*score+100;
          else if(D<Radius/5)*score=*score+80;
          D=Distance(m[1].x,m[1].y,p,q);
          if(D<Radius/10)*score=*score-100;
          else if(D<Radius/5)*score=*score-80;
          clear(m[1].x,Radius/5,terrain);
        }
        //fragment 3
        i=m[2].x/W;
        if(m[2].x>=0&&m[2].x<22.5&&m[2].y>=terrain[i]&&m[2].f==0){
          w.RenderEllipse(Position(m[2].x,16-m[2].y),Position(m[2].x+0.02,16-m[2].y+.02),Cyan,false);
        }
        else if(m[2].x>=0&&m[2].x<22.5&&m[2].r>=Radius/5&&m[2].f==0){
          w.RenderEllipse(Position(m[2].x-m[2].r,16-m[2].y-m[2].r),Position(m[2].x+m[2].r,16-m[2].y+m[2].r),Cyan,false);m[2].f++;
          //scoring
          D=Distance(m[2].x,m[2].y,p2,q2);
          if(D<Radius/10)*score=*score+100;
          else if(D<Radius/5)*score=*score+80;
          D=Distance(m[2].x,m[2].y,p,q);
          if(D<Radius/10)*score=*score-100;
          else if(D<Radius/5)*score=*score-80;
          clear(m[2].x,Radius/5,terrain);
        }
        //fragment 4
        i=m[3].x/W;
        if(m[3].x>=0&&m[3].x<22.5&&m[3].y>=terrain[i]&&m[3].f==0){
          w.RenderEllipse(Position(m[3].x,16-m[3].y),Position(m[3].x+0.02,16-m[3].y+.02),Cyan,false);
        }
        else if(m[3].x>=0&&m[3].x<22.5&&m[3].r>=Radius/5&&m[3].f==0){
          w.RenderEllipse(Position(m[3].x-m[3].r,16-m[3].y-m[3].r),Position(m[3].x+m[3].r,16-m[3].y+m[3].r),Cyan,false);m[3].f++;
          //scoring
          D=Distance(m[3].x,m[3].y,p2,q2);
          if(D<Radius/10)*score=*score+80;
          else if(D<Radius/5)*score=*score+60;
          D=Distance(m[3].x,m[3].y,p,q);
          if(D<Radius/10)*score=*score-80;
          else if(D<Radius/5)*score=*score-60;
          clear(m[3].x,Radius/5,terrain);
        }
        //fragment 5
        i=m[4].x/W;
        if(m[4].x>=0&&m[4].x<22.5&&m[4].y>=terrain[i]&&m[4].f==0){
          w.RenderEllipse(Position(m[4].x,16-m[4].y),Position(m[4].x+0.02,16-m[4].y+.02),Cyan,false);
        }
        else if(m[4].x>=0&&m[4].x<22.5&&m[4].r>=Radius/5&&m[4].f==0){
          w.RenderEllipse(Position(m[4].x-m[4].r,16-m[4].y-m[4].r),Position(m[4].x+m[4].r,16-m[4].y+m[4].r),Cyan,false);m[4].f++;
          //scoring
          D=Distance(m[4].x,m[4].y,p2,q2);
          if(D<Radius/10)*score=*score+80;
          else if(D<Radius/5)*score=*score+60;
          D=Distance(m[4].x,m[4].y,p,q);
          if(D<Radius/10)*score=*score-80;
          else if(D<Radius/5)*score=*score-60;
          clear(m[4].x,Radius/5,terrain);
        }
        G=1;
        for(int j=0;j<5;j++){G=G*m[j].g;}
   
      }//while bracket
      return 1;
    }//if bracket

  

  //explosion
  if(x>=0&&x<22.5){
    for(r=0;r<RADIUS;r+=.01){
      w.RenderEllipse(Position(x-r,16-y-r),Position(x+r,16-y+r),Yellow,false);
      timer(1);
    }
    w.RenderEllipse(Position(x-r,16-y-r),Position(x+r,16-y+r),Cyan,false);
  }
  return 0;

}//trajectory func.


//main program
int ApiMain(){  
  w.Open();
  //making terrain
  float W=0.01;int i=22.5/W;float terrain[i];float score=0;
  for(i=0;i<2250;i++){terrain[i]=TERRAIN;}
  w.RenderRectangle(Position(0,16-TERRAIN),Position(22.5,16),Green,false);
  //making sky
  w.RenderRectangle(Position(0,0),Position(22.5,16-TERRAIN),Cyan,false);

  while(1){
    float p=1,q=5.001,p2=15,t=0,u=1,A=6;i=p2/W;float q2=terrain[i];
    w.RenderEllipse(Position(p2,16-q2),Position(p2+0.1,16-q2+.1),Red,false);
    cout<<"Enter Intial Co-ordinates(p,q) in cm: "; //for(i=0;i<22.5/W;i++){cout<<terrain[i];}
    cout<<"Enter Intial Velocity(u) in m/sec: "; cin>>u;
    cout<<"Enter Angle of projection(A) of missile in degrees: "; cin>>A;
    skipper(p,q,p2,q2,u,A,terrain,&score);
    cout<<"SCORE= "<<score<<endl;
  }
  return 0;
}
